﻿Imports System.IO

Module Module1
    Public Sub Main()
        Dim s1 As New SimpleSensor(New EagleSimpleSensor())
        Dim s2 As New SimpleSensor(New HawkSimpleSensor())

        Dim s3 As New AveragingSensor(New EagleAveragingSensor())
        Dim s4 As New AveragingSensor(New HawkAveragingSensor())

        Dim file_path As String = CurDir()
        file_path = file_path.Substring(0, file_path.LastIndexOf("\"))
        Dim s5 As New StreamingSensor(New EagleStreamingSensor(), New StreamReader(file_path & "\stm_eagle.txt"))
        Dim s6 As New StreamingSensor(New HawkStreamingSensor(), New StreamReader(file_path & "\stm_hawk.txt"))

        Dim i As Integer
        For i = 0 To 4
            Console.WriteLine("Group " & i & ":")
            Console.WriteLine("s1=" & s1.CurrentMeasure)
            Console.WriteLine("s2=" & s2.CurrentMeasure)
            Console.WriteLine("s3=" & s3.CurrentMeasure)
            Console.WriteLine("s4=" & s4.CurrentMeasure)
        Next i

        Console.WriteLine("Dumping the queue for s5:")
        Dim j As Integer = 0
        While s5.IsMeasureAvailable()
            Dim measure As Integer = s5.DequeueMeasure()
            Console.WriteLine("j=" & " value=" & measure)
            j = j + 1
        End While

        Console.WriteLine("Dumping the queue for s6:")
        j = 0
        While s6.IsMeasureAvailable()
            Dim measure As Integer = s6.DequeueMeasure()
            Console.WriteLine("j=" & j & " value=" & measure)
            j = j + 1
        End While

        Console.ReadLine()
    End Sub 'Main
End Module
